<div class="showRegular">
<script>
{literal}
    
var handler = StripeCheckout.configure({
    key: '{/literal}{$publishable_key}',
    image: '{$app.logo}{literal}',
    locale: 'auto',
    token: function(token) {
        // You can access the token ID with `token.id`.
        // Get the token ID to your server-side code for use.
        
        $('#paymentDetails').hide();
        $('#payProcess').val(1);
        $.ajax({
            url: '{/literal}{$url.main}checkout/stripe_process{literal}',
            type: 'POST',
            data: {_token: '{/literal}{$csrf_value}', item_id: {$item->item_id}{literal}, stripeToken: token.id, stripeEmail: token.email, itemName: '{/literal}{$item->item_name}', itemPrice: {$stripe_item_price}, currency: '{$app.currency_code|strtolower}{literal}'},
            dataType: "json",
            beforeSend: function(){
                $('#payButton').prop('disabled', true);
                $('#payButton').html('Please wait...');
            },
            success: function(data){
                $('#payProcess').val(0);
                if(data.status == 1){
                    $('#buynow').hide();
                    $('#txnEmail').html(token.email);
                    $('#orderID').html(data.txnData.id);
                    $('#txnID').html(data.txnData.balance_transaction);
                    $('#paymentDetails').show();
                }else {
                    $('#payButton').prop('disabled', false);
                    $('#payButton').html('Buy Now');
                    alert('Some problem occurred, please try again.');
                }
            },
            error: function(data) {
                $('#payProcess').val(0);
                $('#payButton').prop('disabled', false);
                $('#payButton').html('Buy Now');
                alert('Some problem occurred, please try again but paid.');
            }
        });
    }
});

var stripe_closed = function(){
    var processing = $('#payProcess').val();
    if (processing == 0){
        $('#payButton').prop('disabled', false);
        $('#payButton').html('Pay With Stripe');
    }
};

var eventTggr = document.getElementById('payButton');
if(eventTggr){
    eventTggr.addEventListener('click', function(e) {
        $('#payButton').prop('disabled', true);
        $('#payButton').html('Please wait...');
        
        // Open Checkout with further options:
        handler.open({
            name: '{/literal}{$app.name}',
            description: 'Purchase {$item->item_name} From {$app.name}',
            amount: {$stripe_item_price},
            currency: '{$app.currency_code|strtolower}{literal}',
            closed:	stripe_closed
        });
        e.preventDefault();
    });
}

// Close Checkout on page navigation:
window.addEventListener('popstate', function() {
  handler.close();
});


{/literal}

</script>

</div>